#ifndef _CGETPKS_CPP
#define _CGETPKS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../SQLClass/cSQL.H"
#include "../SQLClass/cRecordSet.H"

#include "CGetPKs.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CGetPKs::Get(CSQL *pcSQL, char *sDB, char *sDBO, char *sTable)
{
	int iTempSz = 0;

	char sSQL[1024];
	char sPKCol[1024];
	char *sBaseSQL = NULL;

	bool bGetPKName = true;
	bool bRetVal = false;

	CRecordSet rsTemp;

    sBaseSQL = "SELECT xSysObjects.Name AS ConstraintName,"
        " xSysColumns.Name AS KeyColumn, xSysTypes.Name AS KeyColumnType,"
        " xSysColumns.Length AS KeyColumnLength, xSysTypes.Status AS TypeStatus"
        " FROM [%s].[%s].SysObjects as xSysObjects,"
        " [%s].[%s].SysIndexes AS xSysIndexes,"
        " [%s].[%s].SysTypes AS xSysTypes,"
        " [%s].[%s].SysIndexKeys AS xSysIndexKeys,"
        " [%s].[%s].SysColumns AS xSysColumns"
        " WHERE xSysObjects.xtype = 'PK' AND xSysTypes.xType = xSysColumns.xType"
        " AND xSysObjects.Name = xSysIndexes.Name AND xSysIndexes.IndId = xSysIndexKeys.IndId"
        " AND xSysIndexes.ID = xSysIndexKeys.ID AND xSysIndexKeys.ColId = xSysColumns.ColId"
        " AND xSysObjects.Parent_Obj = xSysColumns.ID AND xSysObjects.Parent_Obj = Object_Id('[%s].[%s].[%s]')"
        " Order by xSysIndexKeys.KeyNo";

	sprintf(sSQL, sBaseSQL, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sDB, sDBO, sTable);

	if(!pcSQL->Execute(sSQL, &rsTemp))
	{
		rsTemp.Close();
		return false;
	}

    strcpy(sPKTable, sTable);
    strcpy(sPKDBO, sDBO);
    strcpy(sPKDB, sDB);

	if(rsTemp.RowCount > 0)
	{
		sPKs = (char **) calloc(sizeof(char *), rsTemp.RowCount + 1);
		sPKType = (char **) calloc(sizeof(char *), rsTemp.RowCount + 1);
		iPKLen = (int *) calloc(sizeof(int), rsTemp.RowCount + 1);
		iPKStatus = (int *) calloc(sizeof(int), rsTemp.RowCount + 1);

		bAlloc = true;

		iPKs = 0;

		while(rsTemp.Fetch())
		{
			iTempSz = 0;

			if(bGetPKName)
			{
				//Constraint Name.
				rsTemp.sColumnEx(1, sPKName, sizeof(sPKName), &iTempSz);
				bGetPKName = false;
			}

			//Key Column.
			rsTemp.sColumnEx(2, sPKCol, sizeof(sPKCol), &iTempSz);
			sPKs[iPKs] = (char *) calloc(sizeof(char), iTempSz + 1);
			strcpy(sPKs[iPKs], sPKCol);

			//Key Column Type.
			rsTemp.sColumnEx(3, sPKCol, sizeof(sPKCol), &iTempSz);
			sPKType[iPKs] = (char *) calloc(sizeof(char), iTempSz + 1);
			strcpy(sPKType[iPKs], sPKCol);

			//Key Column Length.
			iPKLen[iPKs] = rsTemp.lColumn(4);

			//Type Status.
			iPKStatus[iPKs] = rsTemp.lColumn(5);

			iPKs++;
		}
		bRetVal = true;
	}

	rsTemp.Close();

	return bRetVal;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CGetPKs::Free(void)
{
	if(bAlloc)
	{
		int iKey = 0;

		if(iKey < iPKs)
		{
			while(iKey < iPKs)
			{
				free(sPKs[iKey]);
				free(sPKType[iKey]);
				iKey++;
			}
		}

		free(sPKs);
		free(sPKType);
		free(iPKLen);
		free(iPKStatus);

		bAlloc = false;
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CGetPKs::CGetPKs()
{
	bAlloc = false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CGetPKs::~CGetPKs()
{
	Free();
	bAlloc = false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
